(() => {
  // Visualizer Module
  let audioCtx, analyser, source;
  let frequencyData, bars = [];

function setupEqualizer() {
  const visualizer = document.querySelector('.visualizer');
  if (!visualizer || typeof audio === "undefined") return;

  let totalBars = parseInt(visualizer.dataset.bars) || 100;
  if (window.innerWidth < 480) {
    totalBars = 25; // menos barras en móvil
  }

  // Limpiar barras previas
  visualizer.innerHTML = '';
  bars = [];

  const marginPercent = window.innerWidth < 480 ? 0.1 : 0.2; // margen total horizontal por barra en %

  // ancho disponible para cada barra descontando margen
  const widthPercent = (100 - (totalBars * marginPercent)) / totalBars;

  const barMargin = window.innerWidth < 480 ? '0 0.05%' : '0 0.1%';

  for (let i = 0; i < totalBars; i++) {
    const bar = document.createElement('div');
    bar.classList.add('visualizer-bar');
    bar.style.height = '10%';
    bar.style.opacity = 0.2 + Math.random() * 0.3;
    bar.style.width = `${widthPercent}%`;
    bar.style.margin = barMargin;
    visualizer.appendChild(bar);
    bars.push(bar);
  }

    try {
      audioCtx = new (window.AudioContext || window.webkitAudioContext)();
      analyser = audioCtx.createAnalyser();

      if (!(audio instanceof HTMLAudioElement)) {
        console.warn("Audio element not found or not valid.");
        return;
      }

      source = audioCtx.createMediaElementSource(audio);
      source.connect(analyser);
      analyser.connect(audioCtx.destination);
      analyser.fftSize = 256;

      const bufferLength = analyser.frequencyBinCount;
      frequencyData = new Uint8Array(bufferLength);

      animateBars();
    } catch (e) {
      console.error("Error setting up visualizer:", e);
    }
  }

  function animateBars() {
    requestAnimationFrame(animateBars);
    if (!analyser || !frequencyData) return;

    analyser.getByteFrequencyData(frequencyData);
    const step = Math.floor(frequencyData.length / bars.length);

    for (let i = 0; i < bars.length; i++) {
      const value = frequencyData[i * step];
      const height = Math.max(5, value / 255 * 280);
      bars[i].style.height = `${height}%`;
    }
  }

  // Init when DOM is ready and audio is initialized
  document.addEventListener("DOMContentLoaded", () => {
    const checkAudio = setInterval(() => {
      if (typeof audio !== "undefined" && audio instanceof HTMLAudioElement) {
        audio.addEventListener('play', () => {
          if (!audioCtx) setupEqualizer();
        });
        clearInterval(checkAudio);
      }
    }, 200);
  });
})();
