(() => {
  let deferredPrompt;

  // Detectar si el PWA puede ser instalado
  window.addEventListener('beforeinstallprompt', (e) => {
    e.preventDefault();
    deferredPrompt = e;
    showInstallPrompt();
  });

  // Evento cuando el PWA ha sido instalado
  window.addEventListener('appinstalled', () => {
    hideInstallPrompt();
  });

  // Verificar instalación al cargar
  window.addEventListener('load', async () => {
    try {
      const isInstalled = await checkInstallation();
      isInstalled ? hideInstallPrompt() : showInstallPrompt();
    } catch (error) {
      console.error("Error checking installation status:", error);
    }
  });

  // Verificar si ya está instalada la app
  async function checkInstallation() {
    try {
      if ('getInstalledRelatedApps' in navigator) {
        const relatedApps = await navigator.getInstalledRelatedApps();
        return relatedApps.some(app => app.id === 'com.example.portalremix'); // Personaliza este ID
      }

      return window.matchMedia('(display-mode: standalone)').matches ||
             navigator.standalone ||
             document.referrer.includes('android-app://');
    } catch (e) {
      console.warn("Error in checkInstallation:", e);
      return false;
    }
  }

  // Ejecutar la instalación del PWA
  async function installPWA() {
    try {
      if (deferredPrompt) {
        deferredPrompt.prompt();
        const { outcome } = await deferredPrompt.userChoice;

        if (outcome === 'accepted') {
          setTimeout(async () => {
            if (await checkInstallation()) {
              hideInstallPrompt();
            }
          }, 1000);
        }

        deferredPrompt = null;
      } else if (isIOS()) {
        // iOS: la instalación es manual
      } else if (isAndroid()) {
        const installed = await checkInstallation();
        if (!installed) {
          // Si no está instalada, no se hace nada
        }
      } else {
        // Mostrar popup para navegadores no compatibles
        const popup = document.getElementById('popupIncompatibilidad');
        if (popup) {
          popup.style.display = 'block';
        }
      }

      hideInstallPrompt();
    } catch (error) {
      console.error("Error during installation:", error);
    }
  }

  // Mostrar mensaje para instalar
  function showInstallPrompt() {
    const el = document.querySelector('.install-prompt');
    if (el) {
      checkInstallation().then(installed => {
        if (!installed) el.style.display = 'flex';
      }).catch(err => {
        console.warn("Failed to show install prompt:", err);
      });
    }
  }

  // Ocultar mensaje
  function hideInstallPrompt() {
    const el = document.querySelector('.install-prompt');
    if (el) el.style.display = 'none';
  }

  // Detectar iOS
  function isIOS() {
    const userAgent = navigator.userAgent.toLowerCase();
    return /iphone|ipad|ipod/.test(userAgent) || (userAgent.includes('mac') && 'ontouchend' in document);
  }

  // Detectar Android
  function isAndroid() {
    return /android/i.test(navigator.userAgent);
  }

  // Cerrar popup
  function cerrarPopup() {
    const popup = document.getElementById("popupIncompatibilidad");
    if (popup) popup.style.display = "none";
  }

  // Mostrar popup con mensaje personalizado
  function mostrarPopup(mensaje) {
    const popup = document.getElementById("popupIncompatibilidad");
    const mensajeEl = document.getElementById("popupMensaje");
    if (popup && mensajeEl) {
      mensajeEl.innerText = mensaje;
      popup.style.display = "block";
    }
  }

  // Inicializar botón de instalación
  document.addEventListener('DOMContentLoaded', () => {
    const installButton = document.querySelector('.install-prompt button');
    if (installButton) {
      installButton.addEventListener('click', installPWA);
    }
  });

  // Exponer funciones globales necesarias
  window.cerrarPopup = cerrarPopup;
  window.mostrarPopup = mostrarPopup;
})();
