(() => {
  // Visualizer Module
  let audioCtx, analyser, source;
  let frequencyData, bars = [];

  function setupEqualizer() {
    const visualizer = document.querySelector('.visualizer');
    if (!visualizer || typeof audio === "undefined") return;

    let totalBars = parseInt(visualizer.dataset.bars) || 100;
    if (window.innerWidth < 480) {
      totalBars = 25; // fewer bars on mobile
    }

    // Clear previous bars
    visualizer.innerHTML = '';
    bars = [];

    const marginPercent = window.innerWidth < 480 ? 0.1 : 0.2; // total horizontal margin per bar in %

    // Available width for each bar after margin
    const widthPercent = (100 - (totalBars * marginPercent)) / totalBars;

    const barMargin = window.innerWidth < 480 ? '0 0.05%' : '0 0.1%';

    for (let i = 0; i < totalBars; i++) {
      const bar = document.createElement('div');
      bar.classList.add('visualizer-bar');
      bar.style.height = '10%';
      bar.style.opacity = 0.2 + Math.random() * 0.3;
      bar.style.width = `${widthPercent}%`;
      bar.style.margin = barMargin;
      visualizer.appendChild(bar);
      bars.push(bar);
    }

    try {
      audioCtx = new (window.AudioContext || window.webkitAudioContext)();
      analyser = audioCtx.createAnalyser();

      if (!(audio instanceof HTMLAudioElement)) {
        console.warn("Audio element not found or invalid.");
        return;
      }

      source = audioCtx.createMedi
