// Main radio configuration
const radioConfig = {
  streamUrl: 'https://sonic.onlineaudience.co.uk/8000/stream',
  streamInfoUrl: 'https://sonic.onlineaudience.co.uk/cp/get_info.php?p=8000',
  defaultCover: 'img/logo.png',
  stationLogo: 'img/envivo.gif',
  stationName: 'Londons Energy Extra',
  stationSlogan: 'Music Speak Louder Than Words',
  websiteUrl: 'https://londonsenergyradio.co.uk',
  facebookUrl: 'https://www.facebook.com/londonsenergyradio/',
  twitterUrl: 'https://x.com/londonsenergyuk',
  whatsappNumber: '+447565167387            ',
  instagramUrl: 'https://instagram.com/londonsenergyradio',
  tiktokUrl: 'https://tiktok.com/@londonsenergyradio'
};

let audio;
let isPlaying = true;
let currentSong = '';

document.addEventListener('DOMContentLoaded', () => {
  updateSocialLinks();
});

// Initialize player and its events
function initPlayer() {
  setInitialImages();
  updateSocialLinks();

  audio = new Audio(radioConfig.streamUrl);
  audio.crossOrigin = "anonymous";
  audio.preload = 'auto';

  const title = document.getElementById('title');
  const artist = document.getElementById('artist');
  if (title) title.textContent = radioConfig.stationName;
  if (artist) artist.textContent = 'Live';

  const playBtn = document.querySelector('.play-btn');
  if (playBtn) playBtn.addEventListener('click', togglePlay);

  // Setup Media Session API
  if ('mediaSession' in navigator) {
    navigator.mediaSession.metadata = new MediaMetadata({
      title: radioConfig.stationName,
      artist: 'Live',
      artwork: [{ src: radioConfig.defaultCover, sizes: '512x512', type: 'image/png' }]
    });

    navigator.mediaSession.setActionHandler('play', () => !isPlaying && togglePlay());
    navigator.mediaSession.setActionHandler('pause', () => isPlaying && togglePlay());
  }

  updateNowPlaying();
  setInterval(updateNowPlaying, 10000);
}

window.addEventListener('DOMContentLoaded', initPlayer);

// Play/pause control
function togglePlay() {
  if (!audio) return;
  const btn = document.querySelector('.play-btn');

  if (isPlaying) {
    audio.pause();
    isPlaying = false;
    if (btn) {
      btn.innerHTML = '<i class="fas fa-play"></i>';
      btn.classList.remove('playing');
    }
  } else {
    audio.play().catch(console.error);
    isPlaying = true;
    if (btn) {
      btn.innerHTML = '<i class="fas fa-pause"></i>';
      btn.classList.add('playing');
    }
  }
}

// Update now playing info and artwork using get_info + iTunes backup
async function updateNowPlaying() {
  const titleEl = document.querySelector('.track-title');
  const artistEl = document.querySelector('.artist');

  try {
    const infoResponse = await fetch(radioConfig.streamInfoUrl);
    const infoData = await infoResponse.json();
    const songTitle = infoData?.title || radioConfig.stationName;
    let coverArt = infoData?.art || '';
    let foundFromItunes = false;

    // If coverArt missing or generic, search iTunes as fallback
    if (!coverArt || coverArt.includes('nodj') || coverArt.endsWith('.gif')) {
      const apiUrl = `https://api.streamafrica.net/new.search.php?query=${encodeURIComponent(songTitle)}&service=itunes`;
      const itunesResponse = await fetch(apiUrl);
      const itunesData = await itunesResponse.json();

      if (itunesData?.results?.length > 0) {
        const result = itunesData.results[0];
